from setuptools import setup, find_packages

setup(
    name='continual_rl',
    version='1.0',
    description='Continual reinforcement learning baselines and standard experiments.',
    author='Sam Powers',
    author_email='snpowers@cs.cmu.edu',
    packages=find_packages(),
    py_modules=['continual_rl.available_policies', 'continual_rl.experiment_specs'],
    install_requires=['setuptools==59.5.0',
                      'uuid',
                      'numpy==1.23.5',
                      'tensorboard',
                      'torch-ac',
                      'gym==0.25.1', # for procgen
                      'gymnasium==0.29.1', # for minigrid
                      'minigrid==2.3.1',
                      'mujoco==3.1.4',
                      'mujoco-py==2.0.2.5',
                      'gym[atari]<=0.25.2',
                      'atari-py==0.2.5',
                      'moviepy',
                      'dotmap',
                      'psutil',
                      'opencv-python',
                      'pygame==2.5.2',
                      'tensorboard',
                      'torch>=2.0.1',
                    ]
)
